package pt.caf_pbs.schooldiskclient.ui;


import android.app.Activity;
import android.content.Intent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.ProgressBar;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import pt.caf_pbs.schooldiskclient.R;

import pt.caf_pbs.schooldiskclient.adapter.ListViewAdapterSubject;

import pt.caf_pbs.schooldiskclient.dto.InstructorDTO;
import pt.caf_pbs.schooldiskclient.dto.LectureDTO;
import pt.caf_pbs.schooldiskclient.dto.Mapper;
import pt.caf_pbs.schooldiskclient.dto.SubjectDTO;
import pt.caf_pbs.schooldiskclient.helper.Utils;
import pt.caf_pbs.schooldiskclient.model.Instructor;
import pt.caf_pbs.schooldiskclient.model.Subject;
import pt.caf_pbs.schooldiskclient.service.RequestsService;

import java.util.ArrayList;
import java.util.List;

public class SubjectsActivity extends AppCompatActivity {

    private ListView lv;
    private ProgressBar pdRing;
    private List<Subject> subjectsList;
    private ListViewAdapterSubject adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_subjects);
        pdRing = (ProgressBar) findViewById(R.id.progressBar);
        pdRing.setVisibility(ProgressBar.INVISIBLE);
        lv = (ListView) findViewById(R.id.listView);
        subjectsList = new ArrayList();
        adapter = new ListViewAdapterSubject(this, subjectsList);
        lv.setAdapter(adapter);
        getSubjectsFromWs();

        Intent intent = getIntent();
        boolean pick = intent.getBooleanExtra(Utils.PICK,false);
        if(pick){
            String initials = intent.getStringExtra(Utils.ID);
            lv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                    Subject subject= (Subject) adapter.getItem(i);
                    SubjectDTO subjectDTO = Mapper.subject2SubjectDTO(subject);
                    LectureDTO lectureDTO = Mapper.subjectDTO2LectureDTO(subjectDTO);
                    postInstructorLecture2WS(initials,lectureDTO);


                }
            });
        }

    }

    private void getSubjectsFromWs() {
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);
                    }
                });
                List<Subject> list = RequestsService.getSubjects(SubjectsActivity.this);
                subjectsList.clear();
                subjectsList.addAll(list);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        adapter.notifyDataSetChanged();
                        pdRing.setVisibility(ProgressBar.GONE);
                    }
                });
            }
        }.start();
    }
    private void postInstructorLecture2WS(String initials, LectureDTO lectureDTO) {
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);
                    }
                });
                RequestsService.addInstructorLecture(initials, lectureDTO, SubjectsActivity.this);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.INVISIBLE);
                        Intent intent = new Intent();
                        setResult(Activity.RESULT_OK, intent);
                        finish();
                    }
                });
            }
        }.start();
    }
}
